#!/usr/bin/python
import socket
import datetime
import time
import sqlite3
import sys

TCP_IP = "0.0.0.0"
TCP_PORT = 8080

try:
    #connectie sqlite database
    database = sqlite3.connect('test.db', check_same_thread=False)
    d = database.cursor()
    #timezone correctie
    offset = datetime.datetime.now() - datetime.datetime.utcnow()
    #starten van tcp/ip socket
    sock = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    sock.bind((TCP_IP, TCP_PORT))
    sock.listen(1)
    #wachten op een inkomende verbinding
    conn, addr = sock.accept()
    databaseName = "db" + str(datetime.datetime.now()).translate(None, " -,!.:;")
    print 'Connection address:', addr, 'database', databaseName
    d.execute("CREATE TABLE '%s'(ID INT PRIMARY KEY NOT NULL, var1 TEXT, var2 TEXT, var3 REAL, var4 REAL)" % databaseName)
    id = 0
    conn.setblocking(False)
    conn.settimeout(10)
    
    while True:
        try:
            data = ""
            data = conn.recv(1024)
            print str(datetime.datetime.now().time()), "@", addr, ":", data.rstrip('\r\n')
            #Controlleer of het een voledige zin is, door de commas te tellen.
            if data.count(',') == 2:
                id=id+1
                #uncomment deze line voor meer debug info
                #print """INSERT INTO %s VALUES(%d,"%s",%s)""" % (databaseName, id, str(datetime.datetime.now()).translate(None, " ,!.:;"), data.rstrip('\r\n'))                
                d.execute("""INSERT INTO %s VALUES(%d,"%s",%s)""" % (databaseName, id, str(datetime.datetime.now()), data.rstrip('\r\n')))
                
        except socket.error, socket.timeout:
            #als er een probleem is met de verbinding of timeout wacht op nieuwe connectie
            print 'Connection close:', addr
            if conn:
                conn.close()
            conn, addr = sock.accept()
            print 'Connection address:', addr
            conn.setblocking(False)
            conn.settimeout(10)
            
        except sqlite3.OperationalError, sqlite3.IntegrityError:
            #bij fouten in het schrijven in de database
            print "database ERROR"
            pass
except (KeyboardInterrupt, SystemExit):
    print 'except exit'
    conn.close()
    sock.close()
    database.commit()
finally:
    print 'closing socket'
    conn.close()
    sock.close()
    database.commit()